// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';
import 'package:sqlite3/sqlite3.dart' as sqlite3;

import 'app_state.dart';
import 'enum.dart';

class BsRow extends StatelessWidget {
  const BsRow({
    super.key,
    required this.data,
    required this.columnsInfoList,
    required this.cellLayout,
    this.defaultColor = Colors.yellow,
    this.selectedColor = Colors.red,
    this.isSelected = false,
    this.rightPadding = 0,
    this.onSelectChanged,
    this.dragHandle,
  });

  static const double rowHeight = 50;

  final sqlite3.Row data;
  final List<ColumnInfo> columnsInfoList;
  final Map<String, dynamic> cellLayout;

  final Color defaultColor;
  final Color selectedColor;
  final bool isSelected;
  final double rightPadding;
  final ValueChanged? onSelectChanged;
  final Widget? dragHandle;

  @override
  Widget build(BuildContext context) {
    //AppState.debug('data: $data');
    return Container(
      color: isSelected ? selectedColor : defaultColor,
      height: BsRow.rowHeight,
      child: InkWell(
        onTap: onSelectChanged == null
            ? null
            : () {
                onSelectChanged!(!isSelected);
              },
        child: Row(
          children: [
            Checkbox(value: isSelected, onChanged: onSelectChanged),

            ...columnsInfoList.map(
              (ColumnInfo columnInfo) => Expanded(
                flex: columnInfo.displaySize.flex,
                child: columnInfo.getContentWidget(data[columnInfo.displayName], cellLayout),
              ),
            ),

            dragHandle != null
                ? Stack(
                    alignment: Alignment.center,
                    children: [
                      SizedBox(width: rightPadding, height: double.infinity),
                      dragHandle!,
                    ],
                  )
                : SizedBox(width: rightPadding),
          ],
        ),
      ),
    );
  }
}
