// Copyright (c) 2025, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// This is a regression test for https://dartbug.com/60396.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/regress_60396_test.dart
//
const LINE_A = 22;
// AUTOGENERATED END

void testeeMain() {
  (() {
    (() {
      return 1 + 2; // LINE_A
    })();
  })();
}

// We define this enum because the bug that this test is a regression test
// against was that Debugger::FindBestFit would sometimes attempt to resolve
// breakpoints in functions with non-real token positions like [_enumToString].
enum MyEnum { A, B }

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  resumeIsolate,
  hasStoppedAtExit,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'regress_60396_test.dart',
      testeeConcurrent: testeeMain,
      pauseOnStart: true,
      pauseOnExit: true,
    );
