import 'package:flex_color_scheme/flex_color_scheme.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

import 'app_theme.dart';
import 'home_page.dart';

// ignore_for_file: unused_import
// ignore_for_file: unreachable_from_main

// -----------------------------------------------------------------------------
/// EXAMPLE: COPY-PASTE PLAYGROUND
//
// Use this example to via copy-paste test a theme using code generated by
// the Themes PlayGround found at:
//
// https://rydmike.com/flexcolorscheme/themesplayground-latest/
// -----------------------------------------------------------------------------
void main() => runApp(const DemoApp());

class DemoApp extends StatefulWidget {
  const DemoApp({super.key});

  @override
  State<DemoApp> createState() => _DemoAppState();
}

class _DemoAppState extends State<DemoApp> {
  ThemeMode themeMode = ThemeMode.system;

  // ignore: unused_field
  late final String? _fontFamily = GoogleFonts.notoSans().fontFamily;
  @override
  Widget build(BuildContext context) {
    // To simulate what the looks like on other platforms if you used platform
    // adaptive themes in FlexColorScheme config, you can uncomment this line,
    // import foundation and set TargetPlatform to desired platform to test.
    //
    // debugDefaultTargetPlatformOverride = TargetPlatform.iOS;

    return MaterialApp(
      debugShowCheckedModeBanner: false,
      title: 'Copy Playground',
      // To use this app with the Flutter SDK default theme and default
      // Material Design 3 color scheme, uncomment and use the theme setup
      // below and comment the copy-pasted themes further below,
      //
      // theme: ThemeData(),
      // darkTheme: ThemeData(brightness: Brightness.dark),

      // This is where you can put a direct copy-pasted theme definition from
      // the Themes Playground. In this case we used the option to get code
      // generated for setup in another file, that is here called:
      // `app_theme.dart`.
      //
      // Try your own new setup code from the
      // Themes Playground app available at:
      // https://rydmike.com/flexcolorscheme/themesplayground-latest/
      // and replace the `app_theme.dart` content with the code generated
      // for your config.
      theme: AppTheme.light,
      darkTheme: AppTheme.dark,
      themeMode: themeMode,

      // If you want to use ThemeData.from a ColorScheme based on a ColorScheme
      // from FlexColorScheme, then comment the other two theme setups above and
      // uncomment the theme setup below, and copy-paste the generated
      // ColorScheme code from the Themes Playground app at
      //
      // https://rydmike.com/flexcolorscheme/themesplayground-latest/
      //
      // over the example ColorSchemes further below, with copy-pasted schemes.
      // This will give you the same colors as with FlexColorScheme, but no
      // other theme customizations FlexColorScheme does when it creates
      // its ThemeData with FlexColorScheme.toTheme or using its
      // FlexThemeData extensions and opinionated component themes. You will
      // need to customize ThemeData yourself and adjust all its quirks.
      //
      // This example is to show that it is possible to also only use the light
      // and dark ColorSchemes generated by FlexColorScheme.
      //
      // theme: ThemeData(colorScheme: lightColorScheme),
      // darkTheme: ThemeData(colorScheme: darkColorScheme),

      // ThemeMode toggle via callback
      home: HomePage(
        themeMode: themeMode,
        onThemeModeChanged: (ThemeMode mode) {
          setState(() {
            themeMode = mode;
          });
        },
      ),
    );
  }
}

// Copy-paste the code for a ColorScheme you want from the
// Themes Playground here and try it with plain vanilla
// ThemeData(colorScheme: flexSchemeLight/flexSchemeDark) by
// uncommenting that section above.

/// Light [ColorScheme] made with FlexColorScheme v8.0.0-dev.1.
/// Requires Flutter 3.22.0 or later.
const ColorScheme lightColorScheme = ColorScheme(
  brightness: Brightness.light,
  primary: Color(0xff413d32),
  onPrimary: Color(0xfffcfcfc),
  primaryContainer: Color(0xffcdc6b7),
  onPrimaryContainer: Color(0xff000000),
  primaryFixed: Color(0xffefe7d8),
  primaryFixedDim: Color(0xffd8d1c2),
  onPrimaryFixed: Color(0xff000000),
  onPrimaryFixedVariant: Color(0xff000000),
  secondary: Color(0xff8f8880),
  onSecondary: Color(0xfffefdfd),
  secondaryContainer: Color(0xfff0e7dd),
  onSecondaryContainer: Color(0xff000000),
  secondaryFixed: Color(0xfff0e7dd),
  secondaryFixedDim: Color(0xffd9d0c7),
  onSecondaryFixed: Color(0xff000000),
  onSecondaryFixedVariant: Color(0xff000000),
  tertiary: Color(0xff585147),
  onTertiary: Color(0xfffdfdfc),
  tertiaryContainer: Color(0xfffaefe1),
  onTertiaryContainer: Color(0xff000000),
  tertiaryFixed: Color(0xfff2e6d9),
  tertiaryFixedDim: Color(0xffdbd0c3),
  onTertiaryFixed: Color(0xff000000),
  onTertiaryFixedVariant: Color(0xff000000),
  error: Color(0xffba1a1a),
  onError: Color(0xffffffff),
  errorContainer: Color(0xffffdad6),
  onErrorContainer: Color(0xff000000),
  surface: Color(0xffffffff),
  onSurface: Color(0xff000000),
  surfaceDim: Color(0xffe4e4e4),
  surfaceBright: Color(0xffffffff),
  surfaceContainerLowest: Color(0xffffffff),
  surfaceContainerLow: Color(0xfffcfcfc),
  surfaceContainer: Color(0xfff8f8f8),
  surfaceContainerHigh: Color(0xfff2f2f2),
  surfaceContainerHighest: Color(0xffececec),
  onSurfaceVariant: Color(0xff000000),
  outline: Color(0xff474747),
  outlineVariant: Color(0xffababab),
  shadow: Color(0xff000000),
  scrim: Color(0xff000000),
  inverseSurface: Color(0xff232323),
  onInverseSurface: Color(0xffffffff),
  inversePrimary: Color(0xffe9e2d2),
  surfaceTint: Color(0xff635e52),
);

// Normally the dark mode ColorScheme would be the matching pair to the
// light one, but it does not have to be. Same applies when you use
// FlexColorScheme to make your ThemeData.

/// Dark [ColorScheme] made with FlexColorScheme v8.0.0-dev.1.
/// Requires Flutter 3.22.0 or later.
const ColorScheme darkColorScheme = ColorScheme(
  brightness: Brightness.dark,
  primary: Color(0xfff1e8d9),
  onPrimary: Color(0xff040404),
  primaryContainer: Color(0xff635e52),
  onPrimaryContainer: Color(0xfffef6e6),
  primaryFixed: Color(0xffefe7d8),
  primaryFixedDim: Color(0xffd8d1c2),
  onPrimaryFixed: Color(0xff16130a),
  onPrimaryFixedVariant: Color(0xff231f16),
  secondary: Color(0xffe5e1d6),
  onSecondary: Color(0xff040404),
  secondaryContainer: Color(0xff7d766e),
  onSecondaryContainer: Color(0xfffcf2e8),
  secondaryFixed: Color(0xfff0e7dd),
  secondaryFixedDim: Color(0xffd9d0c7),
  onSecondaryFixed: Color(0xff16130e),
  onSecondaryFixedVariant: Color(0xff231f19),
  tertiary: Color(0xffd5d3c4),
  onTertiary: Color(0xff040403),
  tertiaryContainer: Color(0xff4c463c),
  onTertiaryContainer: Color(0xfff2e6d9),
  tertiaryFixed: Color(0xfff2e6d9),
  tertiaryFixedDim: Color(0xffdbd0c3),
  onTertiaryFixed: Color(0xff17130b),
  onTertiaryFixedVariant: Color(0xff241f17),
  error: Color(0xffffb4ab),
  onError: Color(0xff310001),
  errorContainer: Color(0xff93000a),
  onErrorContainer: Color(0xffffedea),
  surface: Color(0xff0f0e0a),
  onSurface: Color(0xfff6f0e9),
  surfaceDim: Color(0xff15130f),
  surfaceBright: Color(0xff3b3934),
  surfaceContainerLowest: Color(0xff080705),
  surfaceContainerLow: Color(0xff15130f),
  surfaceContainer: Color(0xff211f1b),
  surfaceContainerHigh: Color(0xff2c2a25),
  surfaceContainerHighest: Color(0xff373430),
  onSurfaceVariant: Color(0xffe9e2d4),
  outline: Color(0xff969084),
  outlineVariant: Color(0xff625e53),
  shadow: Color(0xff000000),
  scrim: Color(0xff000000),
  inverseSurface: Color(0xffe7e2da),
  onInverseSurface: Color(0xff1d1b17),
  inversePrimary: Color(0xff635e52),
  surfaceTint: Color(0xffcdc6b7),
);
