// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';
import 'preferences.dart';

/// Button for the main UI, leading to display of the [Preferences] widget.
class PreferencesButton extends StatelessWidget {
  const PreferencesButton({super.key});

  @override
  Widget build(BuildContext context) {
    ColorScheme colorScheme = Theme.of(context).colorScheme;
    return Material(
      type: MaterialType.transparency,
      child: Tooltip(
        message: 'Preferences',
        child: FloatingActionButton(
          shape: const RoundedRectangleBorder(
            borderRadius: BorderRadius.only(bottomLeft: Radius.circular(BS.cornerButtonRadius)),
          ),
          backgroundColor: colorScheme.surface,
          foregroundColor: colorScheme.onSurface,
          heroTag: null,
          elevation: BS.highButtonElevation,
          onPressed: () {
            Navigator.push(context, MaterialPageRoute(builder: (context) => const Preferences()));
          },
          child: const Icon(Icons.settings),
        ),
      ),
    );
  }
}
