// SPDX-License-Identifier: GPL-3.0-only

import 'enum.dart';
import 'utils.dart';

/// Can be a database or a specific table within a database.
class Location {
  String dbPath;

  /// dynamic also allows null so `dynamic?` is redundant
  dynamic tableId;
  TableType? tableType;

  Location({
    required this.dbPath,
    this.tableId,
    this.tableType,
  });

  @override
  String toString() {
    // ignore: prefer_interpolation_to_compose_strings
    return dbPath + '|' + (tableType?.name ?? '') + '|' + (tableId?.toString() ?? '');
  }

  String get hashPath {
    // ignore: prefer_interpolation_to_compose_strings
    return getMd5Hash(dbPath) + '|' + (tableType?.name ?? '') + '|' + (tableId?.toString() ?? '');
  }

  /// We want identical instances of this Class to be considered equal, rather than the default
  /// which is for equality only to match where an instance is compared to itself.
  /// OpDart rules say that overriding `==` means we must also override `hashCode`.
  @override
  bool operator ==(Object other) {
    return (other is Location) &&
        other.dbPath == dbPath &&
        other.tableId == tableId &&
        other.tableType == tableType;
  }

  @override
  int get hashCode => hashPath.hashCode;
}
