extends VBoxContainer

class_name Table

@export var data: Array

@onready var TableRow = preload("res://scenes/table_row.tscn")

var label_settings: LabelSettings

func _ready():
	label_settings = LabelSettings.new()
	label_settings.font_color = Color.RED
	label_settings.font_size = 20
	
func render():
	for n in get_children():
		n.queue_free()
		
	if data:
		for row_data in data:
			var row = TableRow.instantiate()
			for i in 3:
				var cell = row.get_child(i)
				cell.text = row_data[i]
				if row_data[3]:
					cell.set_label_settings(label_settings)
			if row_data[3]:
				row.get_child(4).hide()
			else:
				var direction = row.get_child(4)
				direction.get_child(0).rotation = row_data[4]
			add_child(row)
