class_name SnakePlayer extends SnakeBase

@onready var joystick: Node2D = $"../Camera/Joystick"

func get_class_name() -> String:
	return "PlayerSnake"

func _ready() -> void:
	# override label color
	$NameLabel.set("theme_override_colors/font_color", Color.RED)
	
func _process(_delta: float) -> void:
	direction = _clamp_angle(
			joystick.direction,
			direction - max_rotation,
			direction + max_rotation)

	#if Input.is_action_pressed("Right"):
		#direction += max_rotation
	#if Input.is_action_pressed("Left"):
		#direction -= max_rotation
	#if Input.is_action_just_pressed("ui_up"):
		#speed = min(speed+5, 35)
	#if Input.is_action_just_pressed("ui_down"):
		#speed = max(speed-5, 5)
	#if Input.is_action_pressed("ui_accept"):
		#speed = 0
	
	speed = speed + (start_speed - speed) * _delta/5
	super._process(_delta)

func accelerate(amount: float) -> void:
	"""Increase or decrease speed in given range."""
	speed = clamp(speed+amount, max(5, start_speed-10), min(35, start_speed+10))

#func _input(event) -> void:
	#if event is InputEventMouseMotion:
		#var c = get_local_mouse_position()
		#var a = get_point_position(get_point_count()-1)
		#var dir = Vector2(cos(deg_to_rad(direction)), sin(deg_to_rad(direction)))
		#var b = a + dir
		#var location = a.x*(b.y-c.y)+b.x*(c.y-a.y)+c.x*(a.y-b.y)
		#if location > 0:
			#direction += 2*log(speed)
		#else:
			#direction -= 2*log(speed)
