extends Node2D

signal pause_game

@onready var color_rect: ColorRect = $ColorRect

var paused: bool = false

var pause_img = preload("res://images/ui/pause.png")
var resume_img = preload("res://images/ui/resume.png")

@onready var pause_resume_button: TouchScreenButton = $PauseResumeButton

func _on_pause_resume_button_pressed() -> void:
	paused = not paused
	if paused:
		pause_resume_button.set_texture_normal(resume_img)
		color_rect.show()
	else:
		pause_resume_button.set_texture_normal(pause_img)
		color_rect.hide()
	pause_game.emit()
