extends Control

class_name Options

signal exit_options
signal change_background(number)

@onready var backgrounds = GetResources.backgrounds

@onready var snakes_label: Label = $MarginContainer/General/GridContainer/SnakesContainer/SnakesLabel
@onready var food_piece_label: Label = $MarginContainer/General/GridContainer/FoodPieceContainer/FoodPieceLabel
@onready var speed_label: Label = $MarginContainer/General/GridContainer/SpeedContainer/SpeedLabel
@onready var background_slider: HSlider = $MarginContainer/General/GridContainer/BackgroundSlider
@onready var music_on: CheckBox = $MarginContainer/General/GridContainer/MusicOn
@onready var show_names: CheckBox = $MarginContainer/General/GridContainer/ShowNames
@onready var snakes_slider: HSlider = $MarginContainer/General/GridContainer/SnakesContainer/SnakesSlider
@onready var food_pieces_slider: HSlider = $MarginContainer/General/GridContainer/FoodPieceContainer/FoodPiecesSlider
@onready var speed_slider: HSlider = $MarginContainer/General/GridContainer/SpeedContainer/SpeedSlider
@onready var movement_toggle: OptionButton = $MarginContainer/General/GridContainer/MovementToggle
@onready var controls_toggle: OptionButton = $MarginContainer/General/GridContainer/ControlsToggle

func _ready() -> void:
	var general_settings = GlobalConfigFile.load_general_settings()
	background_slider.min_value = 0
	background_slider.max_value = backgrounds.size()-1
	background_slider.value = general_settings["background_image"]

	music_on.button_pressed = general_settings["music_on"]
	show_names.button_pressed = general_settings["show_names"]
	snakes_slider.value = general_settings["snakes_number"]
	food_pieces_slider.value = general_settings["food_pieces"]
	speed_slider.value = general_settings["snake_speed"]
	movement_toggle.selected = general_settings["snake_movement"]
	controls_toggle.selected = general_settings["controls_position"]

func _on_exit_button_pressed() -> void:
	exit_options.emit()

func _on_snakes_slider_value_changed(value: float) -> void:
	snakes_label.text = "%d" % value
	GlobalConfigFile.save_general_setting("snakes_number", int(value))
	
func _on_food_pieces_slider_value_changed(value: float) -> void:
	food_piece_label.text = "%d" % value
	GlobalConfigFile.save_general_setting("food_pieces", int(value))

func _on_speed_slider_value_changed(value: float) -> void:
	speed_label.text = "%d" % value
	GlobalConfigFile.save_general_setting("snake_speed", int(value))

func _on_music_on_toggled(toggled_on: bool) -> void:
	GlobalConfigFile.save_general_setting("music_on", toggled_on)

func _on_show_names_toggled(toggled_on: bool) -> void:
	GlobalConfigFile.save_general_setting("show_names", toggled_on)
	

func _on_option_button_item_selected(index: int) -> void:
	GlobalConfigFile.save_general_setting("snake_movement", index)


func _on_background_slider_value_changed(value: float) -> void:
	var number: int = int(value)
	GlobalConfigFile.save_general_setting("background_image", number)
	change_background.emit(number)


func _on_controls_toggle_item_selected(index: int) -> void:
	GlobalConfigFile.save_general_setting("controls_position", index)
