extends Control

class_name Menu

@onready var margin_container: MarginContainer = $MarginContainer
@onready var options: Control = $Options
@onready var player_options: Control = $PlayerOptions
@onready var high_scores_list: Control = $HighScoresList

func _on_start_button_pressed() -> void:
	get_tree().change_scene_to_file("res://scenes/main.tscn")

func _on_player_button_pressed() -> void:
	margin_container.hide()
	player_options.show()

func _on_options_button_pressed() -> void:
	margin_container.hide()
	options.show()

func _on_highscore_button_pressed() -> void:
	margin_container.hide()
	high_scores_list.show()

func close_player_options() -> void:
	margin_container.show()
	player_options.hide()

func close_options() -> void:
	margin_container.show()
	options.hide()

func change_background(number) -> void:
	$TextureRect.texture = GetResources.backgrounds[number]

func close_high_scores_list() -> void:
	margin_container.show()
	high_scores_list.hide()


func _on_quit_button_pressed() -> void:
	get_tree().quit()
