class_name HighScores extends Resource

const HIGH_SCORE_FILE: String = "user://highscores.res"

@export var name_points: Array = []

func _sort_by_points(a, b) -> bool:
	return a[1] > b[1]

func sort_and_slice() -> void:
	name_points.sort_custom(_sort_by_points)
	name_points = name_points.slice(0, 10)
	
func save() -> void:
	sort_and_slice()
	ResourceSaver.save(self, HIGH_SCORE_FILE)

func add_entry(entry: Variant) -> void:
	name_points.append(entry)
	
static func load_or_create() -> HighScores:
	var res
	if FileAccess.file_exists(HIGH_SCORE_FILE):
		res = load(HIGH_SCORE_FILE) as HighScores
	else:
		res = HighScores.new()
	return res
