extends Node

const NAMES_FILE = "res://data/names.txt"

# private variables
@onready var snake_names = _get_names(NAMES_FILE)
@onready var heads = _load_snake_resources("head")
@onready var textures = _load_snake_resources("body")
@onready var noises = _load_snake_resources("noise")

@onready var backgrounds = _load_image_resources("background")

func _get_names(file_path) -> PackedStringArray:
	var file = FileAccess.open(file_path, FileAccess.READ)
	var content = file.get_as_text()
	return content.split("\n")

func _load_image_resources(dir: String) -> Array:
	var resource: Resource
	var resources: Array = []
	for file_name in DirAccess.get_files_at("res://images/"+dir):
		if (file_name.get_extension() == "import"):
			file_name = file_name.replace('.import', '')
		resource = ResourceLoader.load("res://images/"+dir+"/"+file_name)
		if not resources.has(resource):
			resources.append(resource)
	return resources

func _load_snake_resources(type: String) -> Array:
	return _load_image_resources("snake/"+type)
