class_name ComputerSnake extends SnakeBase

var frame_cnt: int = 0

func get_class_name() -> String:
	return "ComputerSnake"


func _process(_delta: float) -> void:
	if Engine.get_process_frames() % 3:
		var all_food = get_tree().get_nodes_in_group("food")
		all_food.append_array(get_tree().get_nodes_in_group("superfood"))
		var min_distance: float = 10000
		var dir: Vector2
	
		for food in all_food:
			if food.position.x > 1500 or food.position.y < -1000 or \
		   		food.position.x < -1500 or food.position.y > 1000:
				continue
			var distance = snake_head.position.distance_to(food.position)
			if food.is_in_group("superfood"): distance /= 2
			if distance < min_distance:
				min_distance = distance
				dir = snake_head.position.direction_to(food.position)

		direction = _clamp_angle(
			dir.angle(),
			direction - max_rotation,
			direction + max_rotation)

		# change speed
		speed += randf() - .5
		speed = clamp(speed, start_speed-2, start_speed+2)
	
	super._process(_delta)
