extends Panel

@onready var textures = GetResources.textures
@onready var noises = GetResources.noises
@onready var heads = GetResources.heads

@onready var body: Line2D = $Body
@onready var head: Sprite2D = $Head

var mat: Material

var number: int

var segment_length: int = 3
var num_points: int = 89

var start_pos = Vector2(175, 60)
var direction = -PI

func _ready() -> void:
	mat = body.material.duplicate()
	
	body.width = 20
	var pos = start_pos
	for i in num_points:
		#var t = 2*PI*i/num_points
		body.add_point(pos, 0)
		pos = pos + segment_length * Vector2(cos(direction), sin(direction))
		#direction -= sin(t)
		if i > num_points/2.2:
			direction += 6./num_points
		else:
			direction -= 6./num_points
	head.position = body.get_point_position(body.get_point_count()-1)
	head.scale = .7 * Vector2.ONE
	
func initialize(nr: int) -> void:
	number = nr
	#if number == selection:
		#set_border()
	#else:
		#remove_border()

	var settings = GlobalConfigFile.load_player_settings(nr)

	body.texture = textures[settings["body"]]

	mat.set_shader_parameter("noise_pattern", noises[settings["noise"]])
	mat.set_shader_parameter("selected_pattern", Color(settings["pattern_color"]))
	mat.set_shader_parameter("selected_fill", Color(settings["fill_color"]))
	body.material = mat

	head.texture = heads[settings["head"]]
	head.material = mat
