extends Panel

@onready var name_label: Label = $VBoxContainer/NameLabel
@onready var snake_panel: Panel = $VBoxContainer/SnakePanel


func initialize(nr: int) -> void:
	if nr < GlobalConfigFile.get_player_count():
		name_label.text = GlobalConfigFile.load_player_settings(nr)["name"]
		snake_panel.initialize(nr)
	else:
		name_label.text = ""

func set_border() -> void:
	var sb = StyleBoxFlat.new()
	sb.bg_color = Color("ffffff5e")
	sb.border_color = Color.RED
	sb.border_width_bottom = 4
	sb.border_width_top = 4
	sb.border_width_left = 4
	sb.border_width_right = 4
	self.add_theme_stylebox_override("panel", sb)

func remove_border() -> void:
	self.remove_theme_stylebox_override("panel")
