extends Control

signal exit_player_options

@onready var config_snake: Control = $ConfigSnake
@onready var snake_panels: HBoxContainer = $MarginContainer/VBoxContainer/HBoxContainer/ScrollContainer/SnakePanels
@onready var selected_snake: Panel = $MarginContainer/VBoxContainer/HBoxContainer/VBoxContainer/SelectedSnake
@onready var scroll_container: ScrollContainer = $MarginContainer/VBoxContainer/HBoxContainer/ScrollContainer

var snake_info: PackedScene = preload("res://scenes/snake_info.tscn")
var player_select_delete_buttons: PackedScene = preload("res://scenes/player_select_delete_buttons.tscn")

func _ready() -> void:
	update_player_selection()
	
func update_player_selection() -> void:
	# set selected snake
	selected_snake.set_border()
	selected_snake.initialize(0)
	
	# show available snakes
	for child in snake_panels.get_children():
		child.free()
		
	for i in range(1, GlobalConfigFile.get_player_count()):
		var container = VBoxContainer.new()
		container.add_theme_constant_override("separation", -32)
		snake_panels.add_child(container)

		var si = snake_info.instantiate()
		container.add_child(si)
		si.initialize(i)

		var bu = player_select_delete_buttons.instantiate()
		container.add_child(bu)
		bu.set_number(i)
		bu.connect("select", _set_selection)
		bu.connect("delete", _delete_snake)

func _set_selection(nr: int) -> void:
	selected_snake.initialize(nr)
	snake_panels.get_child(nr-1).get_child(0).initialize(0)
	GlobalConfigFile.save_player_selection(nr)

func _delete_snake(nr: int) -> void:
	GlobalConfigFile.delete_player(nr)
	for i in range(nr, snake_panels.get_child_count()):
		snake_panels.get_child(i).get_child(1).set_number(i)
	snake_panels.get_child(nr-1).call_deferred("free")

func _edit_snake() -> void:
	$MarginContainer.hide()
	config_snake.set_selection(0)
	config_snake.show()

func _on_player_edit_new_buttons_new() -> void:
	GlobalConfigFile.add_empty_player()
	GlobalConfigFile.save_player_selection(GlobalConfigFile.get_player_count()-1)
	update_player_selection()

func _on_config_snake_save() -> void:
	config_snake.hide()
	update_player_selection()
	$MarginContainer.show()

func _on_exit_button_pressed() -> void:
	exit_player_options.emit()
