extends Sprite2D

@onready var parent: Node2D = $".."

var pressing = false

var radius = 58

var angle = 0

func _ready() -> void:
	radius *= parent.scale.x

func _process(_delta: float) -> void:
	if pressing:
		angle = parent.global_position.angle_to_point(get_global_mouse_position())
		global_position = parent.global_position + Vector2.RIGHT.rotated(angle) * radius
		parent.direction = angle


func _on_touch_screen_button_pressed() -> void:
	pressing = true

func _on_touch_screen_button_released() -> void:
	pressing = false
