extends CanvasLayer

signal restart_game
signal reanimate_snake
signal quit_game

var score_text_emph: String = "[outline_size=15][outline_color=white][center]{score}[/center][/outline_color][/outline_size]"
var score_text_norm: String = "[center]{score}[/center]"
var current_score

@onready var reanimate_buttons: HBoxContainer = $ReanimateButtons
@onready var gameover_buttons: HBoxContainer = $GameoverButtons
@onready var winner_label: Label = $WinnerLabel


func update_score(score, last: bool = false) -> void:
	"""Update the score."current_score
	
	If last is set to true do not remove the emphasis
	"""
	current_score = score
	$ScoreLabel.text = score_text_emph.format({"score": current_score})
	if not last:
		$ScoreAnimationTimer.start()

func show_message(text):
	$Message.text = text
	$Message.show()
	$MessageTimer.start()
	
func show_player_died():
	show_message(tr("OH_OH"))
	reanimate_buttons.show()
	
func show_game_over(_name: String, _length: String) -> void:
	$MessageTimer.stop()
	$Message.set("theme_override_colors/font_color", Color.RED)
	$Message.text = tr("GAME_OVER")
	$Message.show()
	$WinnerLabel.text = tr("WINNER")%[_name, _length]
	$WinnerLabel.show()
	reanimate_buttons.hide()
	gameover_buttons.show()
	
func _on_quit_button_pressed():
	reanimate_buttons.hide()
	gameover_buttons.hide()
	get_tree().paused = false
	quit_game.emit()
	
func _on_reanimate_button_pressed():
	reanimate_buttons.hide()
	reanimate_snake.emit()

func _on_new_game_button_pressed() -> void:
	gameover_buttons.hide()
	get_tree().paused = false
	restart_game.emit()

func _on_message_timer_timeout():
	$Message.hide()

func _on_score_animation_timer_timeout():
	$ScoreLabel.text = score_text_norm.format({"score": current_score})
