extends Control

signal exit_high_scores_list

@onready var list: VBoxContainer = $MarginContainer/HighScores/List

var high_score_line: PackedScene = preload("res://scenes/high_score_line.tscn")

var high_scores: HighScores



func _on_draw() -> void:
	high_scores = HighScores.load_or_create()
	var name_points = high_scores.name_points
	if name_points.size() > 0:
		# remove eventual children
		for child in list.get_children():
			child.free()
		# add lines
		for i in name_points.size():
			var line = high_score_line.instantiate()
			list.add_child(line)
			line.get_child(0).text = "%d."%(i+1)
			line.get_child(1).text = name_points[i][0]
			line.get_child(2).text = "%d"%name_points[i][1]



func _on_exit_button_pressed() -> void:
	exit_high_scores_list.emit()
