extends Node

var config = ConfigFile.new()
const SETTINGS_FILE = "user://settings.ini"

func _ready() -> void:
	if !FileAccess.file_exists(SETTINGS_FILE):
		config.set_value("general", "background_image", 0)
		config.set_value("general", "music_on", true)
		config.set_value("general", "show_names", true)
		config.set_value("general", "snakes_number", 15)
		config.set_value("general", "food_pieces", 200)
		config.set_value("general", "snake_speed", 15)
		config.set_value("general", "snake_movement", 0)
		config.set_value("general", "controls_position", 1)
		add_empty_player()
		config.save(SETTINGS_FILE)
	else:
		config.load(SETTINGS_FILE)
		
func save_general_setting(key: String, value: Variant) -> void:
	config.set_value("general", key, value)
	config.save(SETTINGS_FILE)
	
func load_general_settings() -> Dictionary:
	var general_settings: Dictionary = {}
	for key in config.get_section_keys("general"):
		general_settings[key] = config.get_value("general", key)
	return general_settings

func add_empty_player() -> void:
	var nr = get_player_count()
	config.set_value("player-%d"%nr, "name", "")
	config.set_value("player-%d"%nr, "head", 0)
	config.set_value("player-%d"%nr, "body", 0)
	config.set_value("player-%d"%nr, "noise", 0)
	config.set_value("player-%d"%nr, "pattern_color", "#ffffff")
	config.set_value("player-%d"%nr, "fill_color", "#000000")
	config.save(SETTINGS_FILE)
		
func save_player_selection(nr: int) -> void:
	var old = load_player_settings(0)
	var new = load_player_settings(nr)
	save_player_dict(nr, old)
	save_player_dict(0, new)

func get_player_count() -> int:
	"""Return number of configured players."""
	var count: int = 0
	while config.has_section("player-%d"%count):
		count += 1
	return count

func delete_player(number: int) -> void:
	"""Delete a player entry."""
	var last = get_player_count()
	if number > 0 and number < last:
		for i in range(number+1, last):
			save_player_dict(i-1, load_player_settings(i))
		config.erase_section("player-%d"%(last-1))
		config.save(SETTINGS_FILE)
		
func save_player_dict(number: int, player_dict: Dictionary) -> void:
	for key in player_dict:
		config.set_value("player-%d"%number, key, player_dict[key])
	config.save(SETTINGS_FILE)
	
func save_player_settings(number: int, key: String, value: Variant) -> void:
	config.set_value("player-%d"%number, key, value)
	config.save(SETTINGS_FILE)
	
func load_player_settings(number: int) -> Dictionary:
	var player_settings: Dictionary = {}
	for key in config.get_section_keys("player-%d"%number):
		player_settings[key] = config.get_value("player-%d"%number, key)
	return player_settings
	
