/*
 * Copyright (c) 2023 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.features.itemcreate.creditcard

import proton.android.pass.common.api.Option
import proton.android.pass.domain.CustomFieldType
import proton.android.pass.domain.ItemId
import proton.android.pass.domain.ShareId
import proton.android.pass.domain.attachments.AttachmentId
import java.net.URI

sealed interface BaseCreditCardNavigation {
    data object Upgrade : BaseCreditCardNavigation
    data object CloseScreen : BaseCreditCardNavigation
    data object DismissBottomsheet : BaseCreditCardNavigation
    data object AddAttachment : BaseCreditCardNavigation
    data object UpsellAttachments : BaseCreditCardNavigation

    data class OpenAttachmentOptions(
        val shareId: ShareId,
        val itemId: ItemId,
        val attachmentId: AttachmentId
    ) : BaseCreditCardNavigation

    @JvmInline
    value class DeleteAllAttachments(val attachmentIds: Set<AttachmentId>) : BaseCreditCardNavigation

    @JvmInline
    value class OpenDraftAttachmentOptions(val uri: URI) : BaseCreditCardNavigation

    data object AddCustomField : BaseCreditCardNavigation
    data class CustomFieldTypeSelected(val type: CustomFieldType) : BaseCreditCardNavigation

    data class CustomFieldOptions(val currentValue: String, val index: Int) : BaseCreditCardNavigation
    data class EditCustomField(val currentValue: String, val index: Int) : BaseCreditCardNavigation
    data object RemovedCustomField : BaseCreditCardNavigation

    @JvmInline
    value class TotpSuccess(val results: Map<String, Any>) : BaseCreditCardNavigation
    data object TotpCancel : BaseCreditCardNavigation

    @JvmInline
    value class OpenImagePicker(val index: Option<Int>) : BaseCreditCardNavigation

    @JvmInline
    value class ScanTotp(val index: Option<Int>) : BaseCreditCardNavigation
}
