/*
 * Copyright (c) 2023 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.commonui.api

import android.app.Activity
import android.os.Build
import android.view.WindowManager
import proton.android.pass.log.api.PassLogger
import proton.android.pass.preferences.AllowScreenshotsPreference
import proton.android.pass.preferences.value

private const val TAG = "ActivitySecureMode"

fun Activity.setSecureMode(preference: AllowScreenshotsPreference) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
        PassLogger.i(TAG, "setRecentsScreenshotEnabled = false")
        setRecentsScreenshotEnabled(false)
    }

    if (!preference.value()) {
        PassLogger.i(TAG, "Setting FLAG_SECURE. Screenshots prevented")
        window.setFlags(
            WindowManager.LayoutParams.FLAG_SECURE,
            WindowManager.LayoutParams.FLAG_SECURE
        )
    } else {
        PassLogger.i(TAG, "Not setting FLAG_SECURE. Screenshots allowed")
    }
}
