/*
 * Copyright (c) 2024 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.data.impl.usecases.simplelogin

import proton.android.pass.data.api.repositories.SimpleLoginRepository
import proton.android.pass.data.api.usecases.simplelogin.ChangeSimpleLoginAliasMailbox
import proton.android.pass.domain.simplelogin.SimpleLoginAliasMailbox
import javax.inject.Inject

class ChangeSimpleLoginAliasMailboxImpl @Inject constructor(
    private val repository: SimpleLoginRepository
) : ChangeSimpleLoginAliasMailbox {

    override suspend fun invoke(mailboxId: Long, email: String): SimpleLoginAliasMailbox =
        repository.changeAliasMailboxEmail(mailboxId, email)

}
