/*
 * Copyright (c) 2024 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.composecomponents.impl.badge

import androidx.annotation.DrawableRes
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material.Icon
import androidx.compose.material.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.tooling.preview.PreviewParameter
import androidx.compose.ui.unit.dp
import proton.android.pass.commonui.api.PassTheme
import proton.android.pass.commonui.api.Spacing
import proton.android.pass.commonui.api.ThemePreviewProvider
import proton.android.pass.composecomponents.impl.R

@Composable
fun CircledBadge(
    modifier: Modifier = Modifier,
    ratio: Float = 1f,
    @DrawableRes icon: Int = R.drawable.ic_pin_filled,
    iconColor: Color = PassTheme.colors.backgroundNorm,
    backgroundColor: Color
) {
    Icon(
        modifier = modifier
            .size(24.dp * ratio)
            .border(
                width = 2.dp * ratio,
                color = iconColor,
                shape = CircleShape
            )
            .padding(2.dp * ratio)
            .background(
                color = backgroundColor,
                shape = CircleShape
            )
            .padding(Spacing.extraSmall * ratio),
        painter = painterResource(icon),
        tint = iconColor,
        contentDescription = null
    )
}

@Preview
@Composable
fun CircledBadgePreview(@PreviewParameter(ThemePreviewProvider::class) isDark: Boolean) {
    PassTheme(isDark = isDark) {
        Surface {
            CircledBadge(
                backgroundColor = PassTheme.colors.noteInteractionNormMajor1
            )
        }
    }
}
