/*
 * Copyright (c) 2023 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.test

import androidx.compose.ui.test.ExperimentalTestApi
import androidx.compose.ui.test.SemanticsMatcher
import androidx.compose.ui.test.hasText
import androidx.compose.ui.test.junit4.ComposeContentTestRule
import androidx.compose.ui.test.performTextReplacement

private const val WAIT_UNTIL_TIMEOUT = 1_000L

@OptIn(ExperimentalTestApi::class)
fun ComposeContentTestRule.waitUntilExists(matcher: SemanticsMatcher, timeoutMillis: Long = WAIT_UNTIL_TIMEOUT) =
    waitUntilNodeCount(matcher, 1, timeoutMillis)

fun ComposeContentTestRule.writeTextAndWait(
    matcher: SemanticsMatcher,
    text: String,
    expectedText: String = text,
    timeoutMillis: Long = WAIT_UNTIL_TIMEOUT
) {
    onNode(matcher).performTextReplacement(text)
    waitUntilExists(matcher.and(hasText(expectedText)), timeoutMillis)
}

