/*
 * Copyright (c) 2025 Proton AG
 * This file is part of Proton AG and Proton Authenticator.
 *
 * Proton Authenticator is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Authenticator is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Authenticator.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.authenticator.shared.ui.domain.components.buttons

import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import proton.android.authenticator.shared.ui.domain.models.UiText
import proton.android.authenticator.shared.ui.domain.theme.Theme

@Composable
fun TopBarActionTextButton(
    text: UiText,
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    isEnabled: Boolean = true,
    textColor: Color = Theme.colorScheme.accent
) {
    TextButton(
        modifier = modifier,
        enabled = isEnabled,
        onClick = onClick,
        colors = ButtonDefaults.textButtonColors()
            .copy(
                containerColor = Color.Transparent,
                disabledContainerColor = Color.Transparent,
                contentColor = textColor,
                disabledContentColor = textColor.copy(alpha = 0.38f)
            )
    ) {
        Text(
            text = text.asString(),
            style = Theme.typography.body1Medium
        )
    }
}
