/// {@template core_type_source}
/// A utility class that holds constant string values representing the paths
/// to various core Dart library files.
///
/// These constants can be used to identify the source of core Dart types.
/// {@endtemplate}
class CoreTypeSource {
  const CoreTypeSource._();

  /// {@template coreLibPath}
  /// The path to the `dart:core` library file.
  /// {@endtemplate}

  /// {@macro coreLibPath}
  ///
  /// Represents the `dart:core` library.
  static const String core = 'dart:core/core.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `bool` type.
  static const String coreBool = 'dart:core/bool.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `double` type.
  static const String coreDouble = 'dart:core/double.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Enum` type.
  static const String coreEnum = 'dart:core/enum.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Function` type.
  static const String coreFunction = 'dart:core/function.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `int` type.
  static const String coreInt = 'dart:core/int.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `num` type.
  static const String coreNum = 'dart:core/num.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Iterable` type.
  static const String coreIterable = 'dart:core/iterable.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `List` type.
  static const String coreList = 'dart:core/list.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Map` type.
  static const String coreMap = 'dart:core/map.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Null` type.
  static const String coreNull = 'dart:core/null.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Object` type.
  static const String coreObject = 'dart:core/object.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Record` type.
  static const String coreRecord = 'dart:core/record.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Set` type.
  static const String coreSet = 'dart:core/set.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `String` type.
  static const String coreString = 'dart:core/string.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Symbol` type.
  static const String coreSymbol = 'dart:core/symbol.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Type` type.
  static const String coreType = 'dart:core/type.dart';

  /// The path to the `dart:async/future.dart` library file.
  ///
  /// Represents the `Future` type.
  static const String asyncFuture = 'dart:async/future.dart';

  /// The path to the `dart:async/future.dart` library file.
  ///
  /// Represents the `FutureOr` type.
  static const String asyncFutureOr = 'dart:async/future.dart';

  /// The path to the `dart:async/stream.dart` library file.
  ///
  /// Represents the `Stream` type.
  static const String asyncStream = 'dart:async/stream.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `BigInt` type.
  static const String coreBigInt = 'dart:core/bigint.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `DateTime` type.
  static const String coreDateTime = 'dart:core/date_time.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Uri` type.
  static const String coreUri = 'dart:core/uri.dart';

  /// {@macro coreLibPath}
  ///
  /// Represents the `Duration` type.
  static const String coreDuration = 'dart:core/duration.dart';
}
