import 'package:analyzer/error/error.dart' hide LintCode;
import 'package:analyzer/error/listener.dart';
import 'package:custom_lint_builder/custom_lint_builder.dart';

PluginBase createPlugin() => _SelfPrivacyLinter();

class _SelfPrivacyLinter extends PluginBase {
  @override
  List<LintRule> getLintRules(final CustomLintConfigs configs) => [
        RoutedPagesNameLintRule(
          suffix: configs
                  .rules[RoutedPagesNameLintRule.lintName]?.json['suffix']
                  ?.toString() ??
              'Page',
        ),
      ];
}

class RoutedPagesNameLintRule extends DartLintRule {
  RoutedPagesNameLintRule({
    this.suffix = 'Page',
  }) : super(code: _code(suffix));

  final String suffix;

  static const String lintName = 'route_page_class_name';

  static LintCode _code(final String suffix) => LintCode(
        name: lintName,
        problemMessage: 'Routed pages must end with "$suffix".',
        errorSeverity: ErrorSeverity.WARNING,
      );

  @override
  void run(
    final CustomLintResolver resolver,
    final ErrorReporter reporter,
    final CustomLintContext context,
  ) {
    context.registry.addClassDeclaration((final node) {
      if (node.metadata.any(
        (final metadata) => metadata.name.name == 'RoutePage',
      )) {
        if (!node.name.lexeme.endsWith(suffix)) {
          reporter.atToken(node.name, code);
        }
      }
    });
  }
}
