# **开发计划/路线图**

**翻译自 [Road Map](Road_Map.md)**

_最后更新：2025.10.02_

## 独立数据库

建立基于 Jetpack Room 的独立数据库：

正在进行中，见 `room-database` 分支

#### 第一阶段 MediaStore 缓存/镜像

_（完成！）_

#### 第二阶段 数据库播放列表

_（完成！）_

#### 第三阶段 数据库收藏

_（完成！）_

#### 第四阶段 艺术家/专辑复杂关系解析

- [x] 表：歌曲/艺术家/专辑

- [x] 相关操作

- [x] 关系解析（一对多&多对多）

- [x] 分割 `artistName`（解析 ';'，'&'，'/'，'\'，','）。

- [ ] 自动与 MediaStore 同步

- [x] Loader 适配

#### 第五阶段 流派增强

- [ ] 表：流派

- [ ] 提取标签中流派和风格，并作分割（解析 ';'，'&'，'/'，'\'，','）

- [ ] Loader 适配

#### 第六阶段 图片缓存

- [ ] 表：艺术家/专辑的图片缓存

- [ ] 相关操作

- [ ] 更新相关的 coil 组件

#### 第七阶段 继续增强

- [ ] 增强搜索

- [ ] 多标签源（Android MediaStore  & JAudioTagger）

- [ ] 解析 Replay-gain 相关标签

## 模块化

分解项目为多个 Gradle 模块，该部分目前筹备中：

- [x] 整理包级结构

- [ ] 分离提取模块 `api`

- [ ] 界面与逻辑模块化分离

- [ ] 进一步分解逻辑成模块

- [ ] 进一步分解界面成模块

- [ ] 提供保留必要模块的精简版本 (暂定)

## 迁移设置至 Protobuf Datastore

将当前的设置后端从 Preference Datastore 迁移到 Protobuf Datastore：

- [ ] 准备

- [ ] 部分迁移所有基于 Json 的自定义数据类型设置

- [ ] 早期阶段备份和兼容性支持

- [ ] 迁移路径过滤器，并移除其旧数据库实现

- [ ] 完全迁移

- [ ] 完全备份和兼容性支持

## 播放器重构

该部分目前正在进行中。

#### 迁移至 Exoplayer (Media3)

将播放器实现迁移到 `Exoplayer`/ `Jetpack Media3`

- [x] 独立 `PlayerController` 实现

- [ ] 作为可选实验功能

- [ ] 放弃旧实现

- [ ] 完全为`Exoplayer`重构架构

- [ ] 支持“缓冲”状态

#### 重构播放队列

- [ ] 将播放队列、历史记录、歌曲播放次数整合为一个数据库

- [ ] 增强播放器，支持 MediaStore 之外的其他来源, 如 Content URI

- [ ] 更新UI等

#### 远程内容播放（暂定）

- [ ] （暂定与规划）扩展播放器，Samba/NFS/SFTP 支持

- [ ] （暂定与规划）重构文件相关的UI

- [ ] ...

#### 原生播放器解码器（暂定，大概率取消）

与 `ffmpeg` 或 `Symphonia` 等原生解码器集成。

- [x] 测试NDK交叉编译

##### Exoplayer 路线

- [ ] 首先迁移至 Exoplayer

- [ ] 编译 Exoplayer 的 `ffmpeg` 解码器库

- [ ] 集成原生解码器

- [ ] Reproducible Builds 支持

##### 纯原生路线 (大概率取消)

- [ ] 构建原生解码器

- [ ] JVM侧支持

- [ ] 原生侧逻辑代码

- [ ] Reproducible Builds 支持

## 增强主播放器 UI

- [x] 弹性 正在播放 类型

- [x] 快进快退支持

- [ ] 更多 正在播放 类型

- [ ] SlidingMusicBar 增强（暂定，可能取消）

## 单元测试

为核心逻辑编写单元测试

## 重新设计 `AlbumDetail` 和 `ArtistDetail`（暂定，可能取消）

（等待规划）

## 播放列表详情 增强（暂定，可能取消）

- [ ] 搜索增强

- [ ] 处理对应文件 Intent

- [ ] 优化编辑

## 其他开发计划

- [ ] 改进 AppIntro（暂定，可能取消）

- [ ] 扩展状态栏歌词支持 ( FlyMe / EvolutionX)