/*
 * Copyright (c) 2022 chr_56
 */

package player.phonograph.model.pages

import player.phonograph.R
import android.content.Context

object Pages {
    const val EMPTY = "EMPTY"
    const val SONG = "SONG"
    const val ALBUM = "ALBUM"
    const val ARTIST = "ARTIST"
    const val PLAYLIST = "PLAYLIST"
    const val GENRE = "GENRE"
    const val FOLDER = "FOLDER"
    const val FILES = "FILES"

    fun getDisplayName(pager: String?, context: Context): String {
        return when (pager) {
            SONG     -> context.getString(R.string.label_songs)
            ALBUM    -> context.getString(R.string.label_albums)
            ARTIST   -> context.getString(R.string.label_artists)
            PLAYLIST -> context.getString(R.string.label_playlists)
            GENRE    -> context.getString(R.string.label_genres)
            FOLDER   -> context.getString(R.string.label_folders)
            FILES    -> context.getString(R.string.label_files)
            EMPTY    -> context.getString(R.string.msg_empty)
            else     -> "UNKNOWN"
        }
    }

    fun getTintedIconRes(pager: String?): Int {
        return when (pager) {
            SONG     -> R.drawable.ic_music_note_white_24dp
            ALBUM    -> R.drawable.ic_album_white_24dp
            ARTIST   -> R.drawable.ic_person_white_24dp
            PLAYLIST -> R.drawable.ic_queue_music_white_24dp
            GENRE    -> R.drawable.ic_bookmark_music_white_24dp
            FOLDER   -> R.drawable.ic_folder_white_24dp
            FILES    -> R.drawable.ic_folder_white_24dp
            else     -> R.drawable.ic_library_music_white_24dp
        }
    }
}