# Phonograph Plus

<p align="center">
    <img src= "fastlane/metadata/android/en-US/images/icon.png" alt="ICON" height="120"/>
</p>

[English](./README.md) |
[简体中文](./README_ZH.md)
<br/>


[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://github.com/chr56/Phonograph_Plus/blob/release/LICENSE.txt)
[![DownloadsStatistics](https://img.shields.io/github/downloads/chr56/Phonograph_Plus/total)](https://github.com/chr56/Phonograph_Plus/releases)
[![Crowdin](https://badges.crowdin.net/phonograph-plus/localized.svg)](https://crowdin.com/project/phonograph-plus)

[![Stable Release Building Status](https://img.shields.io/github/actions/workflow/status/chr56/Phonograph_Plus/stable_release.yml?label=Stable%20Channel%20building)](https://github.com/chr56/Phonograph_Plus/actions/workflows/stable_release.yml)
[![Preview Release Building Status](https://img.shields.io/github/actions/workflow/status/chr56/Phonograph_Plus/preview_release.yml?label=Preview%20Channel%20building)](https://github.com/chr56/Phonograph_Plus/actions/workflows/preview_release.yml)
[![Dev CI Building Status](https://img.shields.io/github/actions/workflow/status/chr56/Phonograph_Plus/dev.yml?label=Dev%20building)](https://github.com/chr56/Phonograph_Plus/actions/workflows/dev.yml)


**维护中和开发中的 [Phonograph](https://github.com/kabouzeid/Phonograph) 独立分支**

Phonograph 原为一款 Android 质感设计的本地音乐播放器。Phonograph Plus 是 Phonograph 的独立分支，自2021年起一直在维护和开发中（原项目自2020起不再活跃并于2023归档）。


## **下载**

[<img src="https://img.shields.io/github/v/release/chr56/phonograph_plus?label=Github%20Releases" alt="Github%20Release">](https://github.com/chr56/Phonograph_Plus/releases/latest)
[<img src="https://img.shields.io/github/v/release/chr56/phonograph_plus?label=Github%20Releases%20(Latest)&include_prereleases" alt="Github%20Release%20(Latest)">](https://github.com/chr56/Phonograph_Plus/releases/)
[<img src="https://img.shields.io/f-droid/v/player.phonograph.plus?label=F-droid" alt="F-droid">](https://f-droid.org/packages/player.phonograph.plus/)

Phonograph Plus 可从 GitHub Release (稳定版通道和预览版通道[^1]) 和 F-droid[^2] (稳定版通道) 上获取。

[^1]: 预览版包名存在后缀 `preview`

[^2]: 在 F-droid 上启用了可重复构建，从 F-Droid 上获取的 APK 应与 GitHub Release 上获取的 APK 完全相同


## **特性**

Phonograph Plus 继承了原版 Phonograph 的所有功能，并进行了扩展。

若了解原版 Phonograph 功能，请见 [与原版 Phonograph 的对比](./docs/Feature_Comparison_ZH.md)。

- 轻量
- 完全离线，无广告
- Material Design 2
- 夜间模式（浅/暗/黑，支持自动切换）
- 自定义主题色（主色调/强调色），支持 Monet 取色
- 最基础音频播放功能（含速度控制、睡眠定时器和系统提供的均衡器）
- 高度灵活的播放队列管理（随机、重复、完全自由的拖动排序、播放队列快照）
- 歌词支持（内嵌或外挂的 .lrc 歌词和纯文本歌词）
- 高度自定义的播放通知
- 高度灵活的音乐库分类，按歌曲、艺术家、专辑、流派和文件夹（扁平或树状）分类，支持多种排序方式，多选支持，支持网格或列表布局等多种布局样式
- 高度自定义的主播放器界面
- Android Auto 支持
- 高度可定制的点击行为
- 路径过滤器（黑/白名单）
- 搜索支持
- 歌曲收藏支持
- 文件播放列表（查看和基本编辑；可置顶播放列表）
- 内部数据库播放列表
- 播放历史和频次记录，灵活间隔的最近添加歌曲
- 音频文件元数据查看器和标签编辑器
- 应用捷径和小部件
- 图片多来源
- 设置备份
- 应用内语言切换
- ...

了解近期的改动，请移步[更新日志](https://phonographplus.github.io/changelogs/changeslogs/changelog-ZH-CN.html)!

## **截屏**
见 [Gallery](docs/Gallery.md)

## **翻译**

[Crowdin](https://crowdin.com/project/phonograph-plus)

## **常见问题**
见 [Trouble Shooting & FAQ](docs/FAQ.md)

## **构建指南与开发指南**

[Build_Instructions.md](docs/Build_Instructions.md)

[Developer Guide](docs/Developer_Guide.md)

## **开发计划**

见 [路线图](docs/Road_Map_ZH.md) 与 [Road Map](docs/Road_Map.md)。

## **仓库镜像**

[![GitHub](https://img.shields.io/badge/Git-Github-Blue)](https://github.com/chr56/Phonograph_Plus/)
[![Codeberg](https://img.shields.io/badge/Git-Codeberg-Blue)](https://codeberg.org/PhonographPlus/Phonograph_Plus)
[![BitBucket](https://img.shields.io/badge/Git-BitBucket-Blue)](https://bitbucket.org/phonograph-plus/phonograph_plus/)

**仅**以上三者视作官方 Git 仓库（互为镜像），其余皆非官方仓库。