/*
 *  Copyright (c) 2022~2023 chr_56
 */

package player.phonograph.ui.modules.search

import player.phonograph.R
import androidx.annotation.StringRes
import androidx.fragment.app.Fragment
import androidx.viewpager2.adapter.FragmentStateAdapter

class SearchResultPageAdapter(
    searchActivity: SearchActivity,
) : FragmentStateAdapter(searchActivity) {

    enum class TabType(@param:StringRes val nameRes: Int) {
        SONG(R.string.label_songs),
        ALBUM(R.string.label_albums),
        ARTIST(R.string.label_artists),
        PLAYLIST(R.string.label_playlists),
        QUEUE(R.string.label_playing_queue);
    }

    override fun getItemCount(): Int = TabType.values().size

    override fun createFragment(position: Int): Fragment {
        return when (TabType.values()[position]) {
            TabType.SONG     -> SongSearchResultPageFragment()
            TabType.ALBUM    -> AlbumSearchResultPageFragment()
            TabType.ARTIST   -> ArtistSearchResultPageFragment()
            TabType.PLAYLIST -> PlaylistSearchResultPageFragment()
            TabType.QUEUE    -> QueueSearchResultPageFragment()
        }
    }

}