/*
 * Copyright (c) 2022 chr_56
 */

package player.phonograph.ui.compose.components

import androidx.compose.foundation.layout.padding
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

@Composable
fun Title(
    title: String,
    modifier: Modifier = Modifier,
    color: Color = MaterialTheme.colors.onSurface,
    horizontalPadding: Dp = 8.dp,
) {
    Text(
        title,
        modifier = modifier.padding(horizontal = horizontalPadding),
        style = TextStyle(fontWeight = FontWeight.Bold, color = color),
    )
}