#!/bin/bash

#APP_ID=player.efis.pfd

# Check if the APK file is provided
#if [ "$#" -ne 1 ]; then
if [ "$#" -ne 2 ]; then
    echo "Usage: $0 <path_to_apk> <app_id>"
    exit 1
fi

APK_PATH=$1
APP_ID=$2

# Check if the APK file exists
if [ ! -f "$APK_PATH" ]; then
    echo "APK file not found: $APK_PATH"
    exit 1
fi

# Get the list of connected devices
devices=$(adb devices | grep -w "device" | awk '{print $1}')

# Check if any devices are connected
if [ -z "$devices" ]; then
    echo "No devices connected."
    exit 1
fi

# Loop through each device and install the APK
for device in $devices; do
    echo "Installing APK on device: $device"
    adb -s "$device" uninstall "$APP_ID" 
    adb -s "$device" install -r "$APK_PATH"
    if [ $? -eq 0 ]; then
        echo "Successfully installed on $device"
    else
        echo "Failed to install on $device"
    fi
done
