/*
 * Copyright (C) 2016 Player One
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package player.ulib;

import android.util.Log;

public class UTrig {

    //
    // Useful constants.
    //
    public static final double M_E		    = 2.7182818284590452354;
    public static final double M_LOG2E		= 1.4426950408889634074;
    public static final double M_LOG10E	    = 0.43429448190325182765;
    public static final double M_LN2		= 0.69314718055994530942;  // Natural log of 2
    public static final double M_LN10		= 2.30258509299404568402;  // Natural log of 10
    public static final double M_PI		    = 3.14159265358979323846;  // pi
    public static final double M_2PI	    = 6.28318530717958647693;  // 2*pi
    public static final double M_PI_2		= 1.57079632679489661923;  // pi/2
    public static final double M_PI_4		= 0.78539816339744830962;  // pi/4
    public static final double M_1_PI		= 0.31830988618379067154;  // 1/pi
    public static final double M_2_PI		= 0.63661977236758134308;  // 2/pi
    public static final double M_2_SQRTPI	= 1.12837916709551257390;  // sqrt(pi)
    public static final double M_SQRT2		= 1.41421356237309504880;  // sqrt(2)
    public static final double M_SQRT1_2	= 0.70710678118654752440;  // sqrt(1/2)


	 private static final double[] isinTbl = { 		0.00000f,
		0.01745f,0.03490f,0.05234f,0.06976f,0.08716f,0.10453f,
		0.12187f,0.13917f,0.15643f,0.17365f,0.19081f,0.20791f,
		0.22495f,0.24192f,0.25882f,0.27564f,0.29237f,0.30902f,
		0.32557f,0.34202f,0.35837f,0.37461f,0.39073f,0.40674f,
		0.42262f,0.43837f,0.45399f,0.46947f,0.48481f,0.50000f,
		0.51504f,0.52992f,0.54464f,0.55919f,0.57358f,0.58779f,
		0.60182f,0.61566f,0.62932f,0.64279f,0.65606f,0.66913f,
		0.68200f,0.69466f,0.70711f,0.71934f,0.73135f,0.74314f,
		0.75471f,0.76604f,0.77715f,0.78801f,0.79864f,0.80902f,
		0.81915f,0.82904f,0.83867f,0.84805f,0.85717f,0.86603f,
		0.87462f,0.88295f,0.89101f,0.89879f,0.90631f,0.91355f,
		0.92050f,0.92718f,0.93358f,0.93969f,0.94552f,0.95106f,
		0.95630f,0.96126f,0.96593f,0.97030f,0.97437f,0.97815f,
		0.98163f,0.98481f,0.98769f,0.99027f,0.99255f,0.99452f,
		0.99619f,0.99756f,0.99863f,0.99939f,0.99985f,1.00000f,
		0.99985f,0.99939f,0.99863f,0.99756f,0.99619f,0.99452f,
		0.99255f,0.99027f,0.98769f,0.98481f,0.98163f,0.97815f,
		0.97437f,0.97030f,0.96593f,0.96126f,0.95630f,0.95106f,
		0.94552f,0.93969f,0.93358f,0.92718f,0.92050f,0.91355f,
		0.90631f,0.89879f,0.89101f,0.88295f,0.87462f,0.86603f,
		0.85717f,0.84805f,0.83867f,0.82904f,0.81915f,0.80902f,
		0.79864f,0.78801f,0.77715f,0.76604f,0.75471f,0.74314f,
		0.73135f,0.71934f,0.70711f,0.69466f,0.68200f,0.66913f,
		0.65606f,0.64279f,0.62932f,0.61566f,0.60182f,0.58779f,
		0.57358f,0.55919f,0.54464f,0.52992f,0.51504f,0.50000f,
		0.48481f,0.46947f,0.45399f,0.43837f,0.42262f,0.40674f,
		0.39073f,0.37461f,0.35837f,0.34202f,0.32557f,0.30902f,
		0.29237f,0.27564f,0.25882f,0.24192f,0.22495f,0.20791f,
		0.19081f,0.17365f,0.15643f,0.13917f,0.12187f,0.10453f,
		0.08716f,0.06976f,0.05234f,0.03490f,0.01745f,-0.00000f,
		-0.01745f,-0.03490f,-0.05234f,-0.06976f,-0.08716f,-0.10453f,
		-0.12187f,-0.13917f,-0.15643f,-0.17365f,-0.19081f,-0.20791f,
		-0.22495f,-0.24192f,-0.25882f,-0.27564f,-0.29237f,-0.30902f,
		-0.32557f,-0.34202f,-0.35837f,-0.37461f,-0.39073f,-0.40674f,
		-0.42262f,-0.43837f,-0.45399f,-0.46947f,-0.48481f,-0.50000f,
		-0.51504f,-0.52992f,-0.54464f,-0.55919f,-0.57358f,-0.58779f,
		-0.60182f,-0.61566f,-0.62932f,-0.64279f,-0.65606f,-0.66913f,
		-0.68200f,-0.69466f,-0.70711f,-0.71934f,-0.73135f,-0.74314f,
		-0.75471f,-0.76604f,-0.77715f,-0.78801f,-0.79864f,-0.80902f,
		-0.81915f,-0.82904f,-0.83867f,-0.84805f,-0.85717f,-0.86603f,
		-0.87462f,-0.88295f,-0.89101f,-0.89879f,-0.90631f,-0.91355f,
		-0.92050f,-0.92718f,-0.93358f,-0.93969f,-0.94552f,-0.95106f,
		-0.95630f,-0.96126f,-0.96593f,-0.97030f,-0.97437f,-0.97815f,
		-0.98163f,-0.98481f,-0.98769f,-0.99027f,-0.99255f,-0.99452f,
		-0.99619f,-0.99756f,-0.99863f,-0.99939f,-0.99985f,-1.00000f,
		-0.99985f,-0.99939f,-0.99863f,-0.99756f,-0.99619f,-0.99452f,
		-0.99255f,-0.99027f,-0.98769f,-0.98481f,-0.98163f,-0.97815f,
		-0.97437f,-0.97030f,-0.96593f,-0.96126f,-0.95630f,-0.95106f,
		-0.94552f,-0.93969f,-0.93358f,-0.92718f,-0.92050f,-0.91355f,
		-0.90631f,-0.89879f,-0.89101f,-0.88295f,-0.87462f,-0.86603f,
		-0.85717f,-0.84805f,-0.83867f,-0.82904f,-0.81915f,-0.80902f,
		-0.79864f,-0.78801f,-0.77715f,-0.76604f,-0.75471f,-0.74314f,
		-0.73135f,-0.71934f,-0.70711f,-0.69466f,-0.68200f,-0.66913f,
		-0.65606f,-0.64279f,-0.62932f,-0.61566f,-0.60182f,-0.58779f,
		-0.57358f,-0.55919f,-0.54464f,-0.52992f,-0.51504f,-0.50000f,
		-0.48481f,-0.46947f,-0.45399f,-0.43837f,-0.42262f,-0.40674f,
		-0.39073f,-0.37461f,-0.35837f,-0.34202f,-0.32557f,-0.30902f,
		-0.29237f,-0.27564f,-0.25882f,-0.24192f,-0.22495f,-0.20791f,
		-0.19081f,-0.17365f,-0.15643f,-0.13917f,-0.12187f,-0.10453f,
		-0.08716f,-0.06976f,-0.05234f,-0.03490f,-0.01745f};
	
	
	private static final double[] icosTbl = {1.00000f,
		0.99985f,0.99939f,0.99863f,0.99756f,0.99619f,0.99452f,
		0.99255f,0.99027f,0.98769f,0.98481f,0.98163f,0.97815f,
		0.97437f,0.97030f,0.96593f,0.96126f,0.95630f,0.95106f,
		0.94552f,0.93969f,0.93358f,0.92718f,0.92050f,0.91355f,
		0.90631f,0.89879f,0.89101f,0.88295f,0.87462f,0.86603f,
		0.85717f,0.84805f,0.83867f,0.82904f,0.81915f,0.80902f,
		0.79864f,0.78801f,0.77715f,0.76604f,0.75471f,0.74314f,
		0.73135f,0.71934f,0.70711f,0.69466f,0.68200f,0.66913f,
		0.65606f,0.64279f,0.62932f,0.61566f,0.60182f,0.58779f,
		0.57358f,0.55919f,0.54464f,0.52992f,0.51504f,0.50000f,
		0.48481f,0.46947f,0.45399f,0.43837f,0.42262f,0.40674f,
		0.39073f,0.37461f,0.35837f,0.34202f,0.32557f,0.30902f,
		0.29237f,0.27564f,0.25882f,0.24192f,0.22495f,0.20791f,
		0.19081f,0.17365f,0.15643f,0.13917f,0.12187f,0.10453f,
		0.08716f,0.06976f,0.05234f,0.03490f,0.01745f,-0.00000f,
		-0.01745f,-0.03490f,-0.05234f,-0.06976f,-0.08716f,-0.10453f,
		-0.12187f,-0.13917f,-0.15643f,-0.17365f,-0.19081f,-0.20791f,
		-0.22495f,-0.24192f,-0.25882f,-0.27564f,-0.29237f,-0.30902f,
		-0.32557f,-0.34202f,-0.35837f,-0.37461f,-0.39073f,-0.40674f,
		-0.42262f,-0.43837f,-0.45399f,-0.46947f,-0.48481f,-0.50000f,
		-0.51504f,-0.52992f,-0.54464f,-0.55919f,-0.57358f,-0.58779f,
		-0.60182f,-0.61566f,-0.62932f,-0.64279f,-0.65606f,-0.66913f,
		-0.68200f,-0.69466f,-0.70711f,-0.71934f,-0.73135f,-0.74314f,
		-0.75471f,-0.76604f,-0.77715f,-0.78801f,-0.79864f,-0.80902f,
		-0.81915f,-0.82904f,-0.83867f,-0.84805f,-0.85717f,-0.86603f,
		-0.87462f,-0.88295f,-0.89101f,-0.89879f,-0.90631f,-0.91355f,
		-0.92050f,-0.92718f,-0.93358f,-0.93969f,-0.94552f,-0.95106f,
		-0.95630f,-0.96126f,-0.96593f,-0.97030f,-0.97437f,-0.97815f,
		-0.98163f,-0.98481f,-0.98769f,-0.99027f,-0.99255f,-0.99452f,
		-0.99619f,-0.99756f,-0.99863f,-0.99939f,-0.99985f,-1.00000f,
		-0.99985f,-0.99939f,-0.99863f,-0.99756f,-0.99619f,-0.99452f,
		-0.99255f,-0.99027f,-0.98769f,-0.98481f,-0.98163f,-0.97815f,
		-0.97437f,-0.97030f,-0.96593f,-0.96126f,-0.95630f,-0.95106f,
		-0.94552f,-0.93969f,-0.93358f,-0.92718f,-0.92050f,-0.91355f,
		-0.90631f,-0.89879f,-0.89101f,-0.88295f,-0.87462f,-0.86603f,
		-0.85717f,-0.84805f,-0.83867f,-0.82904f,-0.81915f,-0.80902f,
		-0.79864f,-0.78801f,-0.77715f,-0.76604f,-0.75471f,-0.74314f,
		-0.73135f,-0.71934f,-0.70711f,-0.69466f,-0.68200f,-0.66913f,
		-0.65606f,-0.64279f,-0.62932f,-0.61566f,-0.60182f,-0.58779f,
		-0.57358f,-0.55919f,-0.54464f,-0.52992f,-0.51504f,-0.50000f,
		-0.48481f,-0.46947f,-0.45399f,-0.43837f,-0.42262f,-0.40674f,
		-0.39073f,-0.37461f,-0.35837f,-0.34202f,-0.32557f,-0.30902f,
		-0.29237f,-0.27564f,-0.25882f,-0.24192f,-0.22495f,-0.20791f,
		-0.19081f,-0.17365f,-0.15643f,-0.13917f,-0.12187f,-0.10453f,
		-0.08716f,-0.06976f,-0.05234f,-0.03490f,-0.01745f,0.00000f,
		0.01745f,0.03490f,0.05234f,0.06976f,0.08716f,0.10453f,
		0.12187f,0.13917f,0.15643f,0.17365f,0.19081f,0.20791f,
		0.22495f,0.24192f,0.25882f,0.27564f,0.29237f,0.30902f,
		0.32557f,0.34202f,0.35837f,0.37461f,0.39073f,0.40674f,
		0.42262f,0.43837f,0.45399f,0.46947f,0.48481f,0.50000f,
		0.51504f,0.52992f,0.54464f,0.55919f,0.57358f,0.58779f,
		0.60182f,0.61566f,0.62932f,0.64279f,0.65606f,0.66913f,
		0.68200f,0.69466f,0.70711f,0.71934f,0.73135f,0.74314f,
		0.75471f,0.76604f,0.77715f,0.78801f,0.79864f,0.80902f,
		0.81915f,0.82904f,0.83867f,0.84805f,0.85717f,0.86603f,
		0.87462f,0.88295f,0.89101f,0.89879f,0.90631f,0.91355f,
		0.92050f,0.92718f,0.93358f,0.93969f,0.94552f,0.95106f,
		0.95630f,0.96126f,0.96593f,0.97030f,0.97437f,0.97815f,
		0.98163f,0.98481f,0.98769f,0.99027f,0.99255f,0.99452f,
		0.99619f,0.99756f,0.99863f,0.99939f,0.99985f};
	
	public UTrig()
    {
		
	}

    //-------------------------------------------------------------------------
    // Fast arctan approximate
    //
    /*  
        http://nghiaho.com/?p=997
        
        Here is one algorithm I tried, which has a reported maximum error 
        0.0015 radians (0.085944 degrees), lowest error in the paper.
       
        The valid range for x is between -1 and 1. 
        
        Comparing the above with the standard C atan 
        function for 1,000,000 calls using GCC gives:	
          FastArcTan = 17.315 ms
          Standard C atan = 60.708 ms
    */
    public static double fastArcTan(double a)
    {
        return M_PI_4*a - a*(Math.abs(a) - 1)*(0.2447 + 0.0663*Math.abs(a));
    }

    public static double fastArcTan2(double dy, double dx)
    {
        //if (true) return Math.atan2(dy, dx); // for now just use Math
        //return  M_PI_4*a - a*(Math.abs(a) - 1)*(0.2447 + 0.0663*Math.abs(a));
        
        double a = dy / dx;
        double abs_a = Math.abs(a); 
        
        if (abs_a < 1)
          return  M_PI_4*a - a*(abs_a - 1)*(0.2447 + 0.0663*abs_a); //http://nghiaho.com/?p=997
        else 
          return M_PI_2*Math.signum(a) - 1/a;  //https://math.stackexchange.com/questions/982838/asymptotic-approximation-of-the-arctangent
    }


    //-------------------------------------------------------------------------
    // sin value
    // phi is integer degrees
	public static float isin(int phi)
	{
	  while (phi < 0) phi = phi + 360;
	  while (phi > 359) phi = phi - 360;
	  return (float) isinTbl[phi];
	}

    //-------------------------------------------------------------------------
    // cos value
    // phi is integer degrees
	public static float icos(int phi)
	{
	  while (phi < 0) phi = phi + 360;
	  while (phi > 359) phi = phi - 360;
	  return (float) icosTbl[phi];
	}

}
