/*
 * Copyright (C) 2016 Player One
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package player.ulib;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * 
 * @author Ananti
 */
public class Config
{

	private Properties configuration;
	private String configurationFile = "config.ini";

	public Config()
	{
		configuration = new Properties();
	}

	public boolean load()
	{
		boolean retval = false;

		try {
			configuration.load(new FileInputStream(this.configurationFile));
			retval = true;
		} 
		catch (IOException e) {
			System.out.println("Configuration error: " + e.getMessage());
		}

		return retval;
	}

	public boolean store()
	{
		boolean retval = false;

		try {
			configuration.store(new FileOutputStream(this.configurationFile), null);
			retval = true;
		} 
		catch (IOException e) {
			System.out.println("Configuration error: " + e.getMessage());
		}

		return retval;
	}

	public void set(String key, String value)
	{
		configuration.setProperty(key, value);
	}

	public String get(String key)
	{
		return configuration.getProperty(key);
	}
}
