use bevy::prelude::bevy_main;

mod android_tracing;

#[bevy_main]
fn main() {

    let logctr = game::log::LoggingController::init_raw(game::log::LoggingConf::default(), || {
        Box::new(android_tracing::AndroidLayer::default())
    });

    let mut app = game::AppBuilder {
        logging_controller: Some(logctr),
        ..game::AppBuilder::default()
    }.build();

    app.run();
}
