use crate::AppMenuState;
use bevy::prelude::*;
use configure_game::ConfigureGamePlugin;
use gamemode_select::GameModeSelectPlugin;
use selector::SelectorPlugin;
use setup_campaign::SetupCampaignPlugin;

mod configure_game;
mod gamemode_select;
mod selector;
mod setup_campaign;

#[derive(Resource, Default)]
pub struct SetupMenuPlugin;
impl Plugin for SetupMenuPlugin {
    fn build(&self, app: &mut App) {
        app.add_sub_state::<SetupMenuState>();
        app.enable_state_scoped_entities::<SetupMenuState>();
        app.add_plugins(SelectorPlugin);
        app.add_plugins(GameModeSelectPlugin);
        app.add_plugins(ConfigureGamePlugin);
        app.add_plugins(SetupCampaignPlugin);
    }
}

#[derive(SubStates, Debug, Default, Hash, Eq, PartialEq, Clone)]
#[source(AppMenuState = AppMenuState::SetupMenu)]
pub enum SetupMenuState {
    /// First screen shown
    /// displays all gamemodes and allows the player to pick one.
    /// Should display a fitting icon, title and short description
    /// for each gamemode
    #[default]
    GameModeSelect,
    /// CAMPAIGN ONLY
    /// displays the campaign groups with tile and description
    /// should redirect to the level selector on group select
    CampaignGroupSelect,
    /// CAMPAIGN ONLY
    /// displays all levels in the already selected campaign group
    /// should redirect to the configure game screen on select
    /// or back to the group select screen
    CampaignLevelSelect,
    /// Additional gamemode configuration
    /// NOTE: could probably be split up later as well
    /// could also have the GameMode as a parameter to make it easier to
    /// split the subconfig screen render systems
    ConfigureGame,
}
