use super::{Translate, NORMAL_TEXT_COLOR, PARAGRAPH_FONT_NAME, SMALL_TEXT_SIZE};
use crate::{
    i18n::Localization,
    settings::{graphics::ShadowQuality, ActiveSettingsBank},
    ui::UiClickEvent,
};
use bevy::{ecs::system::ResMut, math::Vec2, prelude::EventWriter};
use bevy_egui::egui::{self, FontId, RichText};

pub fn graphics_tab(
    ui: &mut egui::Ui,
    window: Vec2,
    mut settings: ResMut<ActiveSettingsBank>,
    localization: &Localization,
    mut click_event: EventWriter<UiClickEvent>,
) {
    egui::Grid::new("graphics_settings")
        .num_columns(4)
        // .min_col_width(window.x/5.0)
        .spacing([window.x / 10.0, window.y / 75.0])
        .striped(true)
        .show(ui, |ui| {
            ui.label(
                RichText::new(localization.translate("config-graphics-vsync"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            );
            ui.checkbox(&mut settings.graphics.vsync, "");
            ui.end_row();

            ui.label(
                RichText::new(localization.translate("config-graphics-hdr"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            );
            ui.checkbox(&mut settings.graphics.hdr, "");
            ui.end_row();

            ui.label(
                RichText::new(localization.translate("config-graphics-shadow"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            );
            egui::ComboBox::new("dropdown-shadow-select", "")
                .selected_text(settings.graphics.shadows.get_name(localization).to_string())
                .show_ui(ui, |ui| {
                    for shadow_quality in ShadowQuality::list() {
                        let shadow_quality_name = shadow_quality.get_name(localization);
                        if ui
                            .selectable_value(
                                &mut settings.graphics.shadows,
                                shadow_quality.clone(),
                                shadow_quality_name,
                            )
                            .clicked()
                        {
                            click_event.send(UiClickEvent);
                        }
                    }
                });
            ui.end_row();

            ui.label(
                RichText::new(localization.translate("config-graphics-debug-text"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            );
            ui.checkbox(&mut settings.graphics.debug_text, "");
            ui.end_row();

            ui.label(
                RichText::new(localization.translate("config-graphics-animations"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            );
            ui.checkbox(&mut settings.graphics.animations, "");
            ui.end_row();

            ui.label(
                RichText::new(localization.translate("config-graphics-water"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            );
            ui.checkbox(&mut settings.graphics.water, "");
            ui.end_row();
        });
}
