use super::{RestartRequiredPopup, NORMAL_TEXT_COLOR, PARAGRAPH_FONT_NAME, SMALL_TEXT_SIZE};
use crate::{
    i18n::{locales::Language, Localization},
    prelude::*,
    settings::{log::LogLevelWrapper, ActiveSettingsBank},
    ui::UiClickEvent,
};
use bevy::{ecs::system::ResMut, math::Vec2, prelude::EventWriter};
use bevy_egui::egui::{self, FontId, RichText};

pub fn general_tab(
    ui: &mut egui::Ui,
    window: Vec2,
    mut settings: ResMut<ActiveSettingsBank>,
    localization: &Localization,
    mut click_event: EventWriter<UiClickEvent>,
    mut restart_required: ResMut<RestartRequiredPopup>,
) {
    egui::Grid::new("general_settings")
        .num_columns(2)
        .spacing([window.x / 15.0, window.y / 150.0])
        .striped(true)
        .show(ui, |ui| {
            ui.add(egui::Label::new(
                RichText::new(localization.translate("config-language-language"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            ));
            egui::ComboBox::new("dropdown-language-select", "")
                .selected_text(
                    RichText::new(settings.lang.get_name(localization).to_string()).font(
                        FontId::new(
                            window.y * SMALL_TEXT_SIZE,
                            egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                        ),
                    ),
                )
                .show_ui(ui, |ui| {
                    if ui
                        .selectable_value(
                            &mut settings.lang,
                            Language::Auto,
                            localization.translate("config-language-system_language"),
                        )
                        .clicked()
                    {
                        click_event.send(UiClickEvent);
                    }
                    for lang in Language::list() {
                        let lang_name = lang.get_name(localization);
                        if ui
                            .selectable_value(&mut settings.lang, lang.clone(), lang_name)
                            .clicked()
                        {
                            click_event.send(UiClickEvent);
                        }
                    }
                });
            ui.end_row();

            ui.add(egui::Label::new(
                RichText::new(localization.translate("pause-game-on-focus-loss"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            ));
            ui.checkbox(&mut settings.game_behaviour.pause_when_unfocused, "");
            ui.end_row();

            ui.add(egui::Label::new(
                RichText::new(localization.translate("config-loglevel"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            ));
            egui::ComboBox::from_label("")
                .selected_text(
                    RichText::new(settings.log.level.get_name(localization).to_string()).font(
                        FontId::new(
                            window.y * SMALL_TEXT_SIZE,
                            egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                        ),
                    ),
                )
                .show_ui(ui, |ui| {
                    for log in LogLevelWrapper::list() {
                        let log_name = log.get_name(localization);
                        let old_level = settings.log.level.clone();
                        if ui
                            .selectable_value(&mut settings.log.level, log, log_name)
                            .clicked()
                        {
                            click_event.send(UiClickEvent);
                            if settings.log.level != old_level {
                                restart_required.shown = true;
                                restart_required.reason = "config-restart-loglevel".into();
                            }
                        }
                    }
                });
        });
    ui.separator();
}
