use serde::{Deserialize, Serialize};

use crate::{
    game::gamemodes::{campaign::levels::CampaignGroupWrapper, GameMode},
    Difficulty,
};

#[derive(Serialize, Deserialize, Debug, Clone)]
#[serde(default)]
pub struct GameBehaviourSettings {
    /// most recently played difficulty level
    pub difficulty: Difficulty,
    ///  pauses the game if the window looses focus
    ///  NOTE: external screenshot tools may also unfocus the window
    pub pause_when_unfocused: bool,
    /// most recently played game mode
    pub gamemode: GameMode,
    /// most recently used Bot
    pub bot_url: String,
    pub bot_usage: bool,
    /// recorder is activated
    pub activate_recorder: bool,
    pub replay_name: String,
    /// most recently selected campaign level
    pub campaign_level: CampaignGroupWrapper,
}

impl Default for GameBehaviourSettings {
    fn default() -> Self {
        Self {
            difficulty: Difficulty::Medium,
            pause_when_unfocused: false,
            gamemode: GameMode::default(),
            bot_url: String::from("localhost:7738"),
            bot_usage: false,
            activate_recorder: false,
            campaign_level: CampaignGroupWrapper::default(),
            replay_name: Default::default(),
        }
    }
}
