use bevy::asset::LoadState;
use bevy::prelude::*;
use bevy::window::WindowResized;
use bevy::winit::WinitWindows;
use terratactician_expandoria::game::asset_loading::AssetLoadedEvent;
use terratactician_expandoria::AppIcon;
use winit::window::Icon;

pub struct WindowManager;

impl Plugin for WindowManager {
    fn build(&self, app: &mut App) {
        app.add_systems(Update, set_window_icon)
            .add_systems(Update, on_resize_system);
    }
}

fn on_resize_system(
    mut resize_reader: EventReader<WindowResized>,
    mut windows: Query<&mut Window>,
) {
    let Ok(mut window) = windows.get_single_mut() else {
        return;
    };

    for e in resize_reader.read() {
        window.resolution.set(e.width, e.height);
    }
}

fn set_window_icon(
    mut events: EventReader<AssetLoadedEvent<AppIcon>>,
    server: Res<AssetServer>,
    assets: Res<Assets<Image>>,
    icon: Res<AppIcon>,
    windows: NonSend<WinitWindows>,
) {
    if events.is_empty() {
        return;
    }
    events.clear();
    // will be none if the handle failed to load
    if let Some(handle) = &icon.icon {
        if let Some(LoadState::Loaded) = server.get_load_state(handle) {
            // try to get app icon asset
            let Some(image) = assets.get(handle) else {
                return;
            };
            let (width, height) = (image.width(), image.height());
            // format app icon image to icon
            let Ok(icon) = Icon::from_rgba(image.data.clone(), width, height) else {
                return;
            };
            // do it for all windows
            for window in windows.windows.values() {
                window.set_window_icon(Some(icon.clone()));
            }
        }
    }
}
