use crate::DisplayMode;
#[cfg(feature = "graphics")]
use basic_tile_functions::CampaignTilesTutorialPlugin;
use bevy::prelude::*;
#[cfg(feature = "graphics")]
use camera::CampaignCameraTutorialPlugin;

#[cfg(feature = "graphics")]
use early_game_tiles::CampaignEarlyGameTutorialPlugin;

#[cfg(feature = "graphics")]
pub mod basic_tile_functions;

#[cfg(feature = "graphics")]
pub mod camera;
#[cfg(feature = "graphics")]
pub mod early_game_tiles;

pub struct CampaignTutorialPlugin {
    pub display_mode: DisplayMode,
}
impl Plugin for CampaignTutorialPlugin {
    #[cfg(feature = "graphics")]
    fn build(&self, app: &mut App) {
        app.add_plugins(CampaignCameraTutorialPlugin {
            display_mode: self.display_mode,
        });
        app.add_plugins(CampaignTilesTutorialPlugin {
            display_mode: self.display_mode,
        });
        app.add_plugins(CampaignEarlyGameTutorialPlugin {
            display_mode: self.display_mode,
        });
    }
    #[cfg(not(feature = "graphics"))]
    fn build(&self, _app: &mut App) {}
}
