use crate::{
    game::{gamemodes::campaign::levels::CampaignChallenge, hand::RandomCore, round::RoundCounter},
    DisplayMode,
};
use bevy::prelude::*;

pub struct CampaignChallengeEasyPlugin {
    pub display_mode: DisplayMode,
}
impl Plugin for CampaignChallengeEasyPlugin {
    fn build(&self, _app: &mut App) {}
}

/// Generates a [`Condition`](bevy_ecs::prelude::Condition)-satisfying closure that returns `true`
/// when the player is in the given level
pub fn level_reached(level: usize) -> impl FnMut(Res<RoundCounter>) -> bool + Clone {
    move |counter| counter.0 == level
}

fn easy_init(world: &mut World) {
    let mut rng_core = world
        .get_resource_mut::<RandomCore>()
        .expect("The corresponding plugin is added by the level group plugin");
    rng_core.change_seed("easy-seed");
}

define_level!(
    CampaignChallenge::ChallengeEasy,
    init: easy_init,
story: [
    {
        id: "easy_intro"
    },
    {
        ref: R1,
        id: "finish-r1",
        goal: level_reached(1)
    },
    {
        ref: R2,
        id: "finish-r2",
        goal: level_reached(2)
    },
    {
        ref: R3,
        id: "finish-r3",
        goal: level_reached(3)
    },
    {
        id: "easy-done"
    }
]);
