use bevy::prelude::*;

#[derive(Component)]
pub struct ErrorDisplay {
    pub title: String,
    pub description: String,
    pub link: Option<String>,
}

impl Default for ErrorDisplay {
    fn default() -> Self {
        Self {
            title: "Unknown error".into(),
            description: "An asset loading error was thrown, without a specific reason. Check the installation or look into the log for more information.".into(),
            link: None,
        }
    }
}
