# 💬 Translations

We use [the project fluent translation framework](https://projectfluent.org/) for translations.

Fluent refers to basic translation units as messages.
Each message is identified by an identifier,
which is also used to show the text in the program.

Fluent aims to be simple to read, 
but it also provides advanced concepts for gender, plurals and conjugations. \
Take a look at the [Fluent Syntax Guide](https://projectfluent.org/fluent/guide/index.html) if you want to learn more.

## 📢 Help translate
TerraTactician-Expandoria is available in multiple languages.
If you want to help translate it into your language,
you can use one of the following methods:

### 📁 Help translate locally
TTE stores translation files, 
separated by language ID, in the `assets/locales` directory.

#### 📝 Adding missing translations
The easiest way to add missing translations,
is to navigate into the `assets/locales` directory,
open the `en/translations.ftl` file as a reference in a new text editor tab,
and then open the `translations.ftl` of the language you are trying to translate.

This allows you to copy missing translation units (messages) from the reference language into your target language and translate them.

For example, your target language (here `de`) might be missing `greet-user`,
so you copy the reference translation from the `en` locale:
```
greet-user = Hello
```

The text on the left-hand side of the equal sign
is referred to as the *message ID* and **must not** be changed, 
the text right-hand side of the equals sign is the text that has to be translated.

In this example, it would simply be replaced with `Hallo`, the German for `Hello`.
```
greet-user = Hallo
```

**Note: messages might span multiple lines. Make sure not to miss parts of the message.**
The [project fluent](https://projectfluent.org/) homepage has a helpful complex example to illustrate this:
```
shared-photos =
    {$userName} {$photoCount ->
        [one] added a new photo
       *[other] added {$photoCount} new photos
    } to {$userGender ->
        [male] his stream
        [female] her stream
       *[other] their stream
    }.
```

Variable content is surrounded by curly brackets `{}`,
and might contain variable names (prefixed with `$`),
these should be preserved in your translation. \
As you can see in the example above, 
translation hints can be added using square brackets,
you should probably keep them as well and only translate the text on their right.

#### 🪧 Adding a new language
To add a new language, simply create a new directory in the `assets/locales` folder.
The locale code of your language should be used as the folder name.
You can find a list of locale codes [here](https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes).

If you want to translate every single message/translation unit in one go,
you could copy the `translations.ftl` from the `en` locale
and simply translate the text. \
However, this should only be done if you translate everything,
as pushing half translated files makes it harder to spot missing translations
and is discouraged.

Instead, you should translate them one message-id at a time, 
as explained in the previous chapter.

You might already have noticed, 
that your new language doesn't show up in the settings menu. 
This is because you still have to register it in the code.

To add the language, 
you will have to open the `src/i18n/locales.rs` file in a text editor,
or an IDE. \
Near the top of the file, you will find a `languages!` macro call,
to register your selected language, you want to add it at the end of the block.
For example, if you wanted to add Spanish, the line would look like this:
```rust
languages![
    // [...]
    (es, Es, "es", "Español"),
];
```

### 🌐 Help translate using Weblate
If you'd rather use a web editor to translate,
head over to [Codeberg's Weblate instance](https://translate.codeberg.org/engage/terratactician-expandoria/)

[![Translation status](https://translate.codeberg.org/widget/terratactician-expandoria/game/multi-auto.svg)](https://translate.codeberg.org/engage/terratactician-expandoria/)

**Note: Weblate doesn't necessarily have the latest source version, and translations might not be merged immediately**

Also, even though Weblate is able to create new languages,
**it is not able to generate the rust code entries for the corresponding languages.**

## 💻 For developers
To translate text in your system,
simply request the `Localization` resource:
```rust
fn my_system(
// ...
    localization: Res<Localization>,
// ...
) {}
```
and import the crate's prelude to make sure the Translate trait is in the scope:
```rust
use crate::prelude::*;
```
(Note: You could also import the trait directly, however this is easier to remember, and if we ever add more traits, the import stays the same)

Now you can use the `translate` method to translate a message using the message ID inside your system:
```rust
localization.translate("message-id")
```
This function looks up the translation of the message-id.
If no language in the fallback chain contains the requested message,
the ID itself is returned.

### 🔍 Translation lookup
The translation system is initialized with up to three languages:
The sub-region (i.e. `de_AT`), the region (i.e. `de`) and the default locale 
(i.e. `en`). \
Most of the time the sub-region won't be set, 
as the region group will be good enough.

This results in the following lookup table:
1. Lookup the translation using the sub-region code (i.e. `de_AT`)
2. Lookup the translation using the region code (i.e. `de`)
3. Lookup the translation in the application default language (`en`)
4. Use the translation ID as the display text
