# 🎒 Resources
In TTE resources/metrics are calculated by integrating the current metrics rate.
The current metrics rate will be calculated, after world/settings changes.

## 📈 Resource calculation pipeline
This is a section of a graph of the scheduleing queue, related to resource calculations.
```mermaid
flowchart TD
    subgraph Receive
        simulate_record
        in_game_handler
    end

    not_in_game_handler -- before --> in_game_handler

    subgraph Prepare
        subgraph Placers
            placer
            keyboard_placer
            bot_placer
            creative_placer
        end
        Placers -. chain .-> UpdateMarker
        subgraph RewardsProcessing
            rewards_time_processor
            rewards_timer_end
            handle_rewards_click            
        end
        Placers -. after .-> RewardsProcessing
        subgraph UpdateTradeRatio
            apply_changes_from_trade_ratio -. chain .-> re_collect_resource_rates
            handle_rewards_click -. after .-> re_collect_resource_rates
        end
        Placers -. after .-> UpdateTradeRatio
        Placers -. after .-> process_manual_redraw
        rewards_timer_end -. after .-> process_manual_redraw
        update_tile_data
    end

    subgraph Simulation
        subgraph ResourcePipeline
            direction TB
            subgraph RPrepare [Prepare]
                debug_text_tick
            end
            subgraph BoosterCalculate
                calc_moai_tile
            end
            subgraph Calculate
                calc_forest_tile
                calc_quarry_tile
                calc_wheat_tile
                calc_windmill_tile
                calc_smallhouse_tile
                calc_doublehouse_tile
                calc_beehive_tile
            end
            subgraph MarketCalculate
                calc_marketplace_tile
            end
            subgraph CollectRates
                collect_resource_rates
            end
            RPrepare -. chain .-> BoosterCalculate
            BoosterCalculate -. chain .-> Calculate
            Calculate -. chain .-> MarketCalculate
            MarketCalculate -. chain .-> CollectRates
        end
        subgraph SimulateMetrics
            update_resources
            track_market_economy
        end
        CollectRates -. after .-> SimulateMetrics
    end

    round_processor

    subgraph AfterSim
        subgraph Reclaim
            apply_placement_timer
            tick_placement_timer
        end
        collect_warnings
        round_end_processor
        update_redraw_cost
        count_christmas_rewards
    end

    round_processor -. after .-> round_end_processor
    round_processor -. after .-> update_redraw_cost


    subgraph NextAuto
        schedule_simulate_record
        simulate_bot
        print_challenge_tick
    end

    Simulation -. after .-> step_recorder
    Prepare -. after .-> receive_recorder -- before --> step_recorder

    Receive -. chain .-> Prepare -. chain .-> Simulation -. chain .-> AfterSim -. chain .-> NextAuto
    tick_timer -- before --> Simulation
```
- Parts of these systems and sets only run on demand.
- The tile specific systems in `ResourcePipeline` or `UpdateTradeRatio` are allowed and supposed to overwrite the Component `MetricsRate` of there respective enties.
- `CollectRates` and `re_collect_resource_rates` change the global `MetricsRate`. No other system is currently allowed to do this, during the game.
