# 🕒 Releasing a new version

We are currently using [Semantic versioning](https://en.wikipedia.org/wiki/Software_versioning#Semantic_versioning) as our versioning scheme.

The version name in the `Cargo.toml` consists of three sections: `<major>.<minor>.<patch>`. \
Breaking changes are indicated by increasing the major number (high risk); 
new, non-breaking features increment the minor number (medium risk); 
and all other non-breaking changes increment the patch number (lowest risk). \
(Note: We maintain the right to increase the version numbers as we see fit.)

In the past we have also used additional meta tags, 
however they have been dropped to make the package easier to package
and focus on a more rolling-style release model.

Ideally, 
bumping the version in the `Cargo.toml` should be done in a separate commit,
with a commit message like: `Bump version: v<major>.<minor>.<patch>`.

Additionally, you have to add the [release information](https://www.freedesktop.org/software/appstream/docs/chap-Metadata.html#tag-releases) 
to the [metainfo file](../../dist/page.codeberg.terratactician_expandoria.metainfo.xml).
```xml
    <release version="$release_version" date="$release_date">
            <url type="details">https://codeberg.org/terratactician-expandoria/game/releases/tag/$release_version</url>
            <description translate="no">
                <p>
                $release_title
                </p>
                <p>
                $release_text
                </p>
                <ul>
                    <li>$changelog_1</li>
                    <li>$changelog_2</li>
                    ...
                </ul>
            </description>
        </release>
```

After updating all affected files,
you should run `git tag -a v<major>.<minor>.<patch>` 
and add a proper release message.

Afterwards, simply push your changes and tags; 
the CI will the build the artifacts and publish them along a release
marked as `prerelease`. \
After testing you can change the release type to `release`.
