# 🧰 Building
To be able to build TerraTactician Expandoria for your platform of choice,
you probably need to install rust and cargo.

The easiest way to do this is by installing rustup.
Rustup also allows you to build for platforms like the web and android.

Check [the rustup website](https://rustup.rs/) for an installation guide.

TerraTactician Expandoria utilizes the Bevy game engine. For additional guides take a look at:
- [Bevy's Getting Started Guide](https://bevyengine.org/learn/quick-start/getting-started/setup/#installing-os-dependencies)
- [The Bevy Cheatbook](https://bevy-cheatbook.github.io/setup/getting-started.html#gpu-drivers)

## 💻 Platforms
The following guide will describe how to compile TerraTactician Expandoria. 

If you do not use an auto bundling feature you must run TTE always in the scope of the git repo or copy the assets folder next to the executable. 

To change the path of the assets folder compile with the feature: `custom-assets-path` and set the compile time variable `TTE_BUILD_ASSETS_DIR` to the desired path.

### 🐧 Linux
To be able to build for linux, you need a couple of libraries.

The needed libraries can be installed under debian like systems with:
```sh
sudo apt-get install g++ pkg-config libx11-dev libasound2-dev libudev-dev libxkbcommon-x11-0
# and for wayland support:
sudo apt-get install libwayland-dev libxkbcommon-dev
```

For other platforms take a look at: [Installing Linux dependencies](https://github.com/bevyengine/bevy/blob/latest/docs/linux_dependencies.md)

Now you can build or run TerraTactician Expandoria with:
```sh
# to run it in debug mode:
cargo run

# to build it for release:
cargo build --release
```

TerraTactician Expandoria can be bundled to an `.deb` file using the following commands:
```sh
# install bundle tool
cargo install cargo-deb

# compile and bundle it
cargo deb
```

### 🪟 Windows
To be able to build for windows, you need Visual Studio 2019 to install some dependencies.

Run the [Visual Studio 2019 build tools installer](https://visualstudio.microsoft.com/de/vs/older-downloads/) and select `Desktop development with C++` to be installed.

Now you can build or run TerraTactician Expandoria with:
```sh
# to run it in debug mode:
cargo run

# to build it for release:
cargo build --release
```

TerraTactician Expandoria can be cross-compiled for windows using linux:
```sh
# install dependencies and target
apt-get install -y -qq tar zip gcc-mingw-w64-x86-64 g++-mingw-w64-x86-64
rustup target add x86_64-pc-windows-gnu

# build the binary 
cargo build --release --target=x86_64-pc-windows-gnu
```

Optionally a `.msi` file can be be build on linux machines:
```sh
# this will only work on debian like systems and install a couple of dependencies
sh dist/build_msi.sh "output_file.msi"
``` 

### 🌐 Web
To be able to build for the web,
you need a couple of things.

First of all,
install the wasm32 target. 
This makes it possible to compile the rust code to a format your browser understands.
```sh
rustup target install wasm32-unknown-unknown
```

To be able to build for the web,
you also need to install `trunk`.
Trunk allows you to build & serve the web version on your computer.
(It even supports hot reloading when you change your files, ✨fancy✨).
```sh
cargo install trunk
```

Afterwards, you can simply build the project. 
The output files are located in `./build`:
```sh
trunk build --release
```

To serve the files on a web server running locally,
run the following command
```sh
trunk serve
```

### 📱 Android (Experimental)

Mobile support is currently considered experimental,
and not officially supported.

You can find Android build instructions in the [`android` repository](https://codeberg.org/terratactician-expandoria/android)

### Other
We are not able to build TerraTactician Expandoria for every platform and architecture. But maybe you can. (e.g. for apple a mac book is required.) Use the links at the top of this page setup a working rust and bevy environment for your system and compiled it.

Useful commands can be:
```sh
# to run it in debug mode:
cargo run

# to build it for release:
cargo build --release
```
