export default function myInitializer() {
  return {
    onStart: () => {
      console.log("Loading...");
      console.time("trunk-initializer");
      document.querySelector("#loading p").textContent = "Preparing ...";
    },
    onProgress: ({ current, total }) => {
      if (!total) {
        console.log("Loading...", current, "bytes");
      } else {
        let percent = Math.round((current / total) * 100);
        console.log("Loading...", percent, "%")
        document.getElementById("progress-bar").style.backgroundPositionX = `${percent}%`
      }
    },
    onComplete: () => {
      console.log("Loading... done!");
      console.timeEnd("trunk-initializer");
      document.getElementById("loading").remove();
    },
    onSuccess: (wasm) => { },
    onFailure: (error) => {
      if (!error.message.startsWith("Using exceptions for control flow, don't mind me. This isn't actually an error!")) {
        console.warn("Loading... failed!", error);
        // display error
        if (document.querySelector("canvas").getContext("webgl2") == null) {
          show_error("Running the game failed. Your browser does not support webgl2.");
        } else {
          show_error("Loading the game failed. Check your internet connection or try again later.");
        }
      }
    }
  }
};

function show_error(msg) {
  let error = document.getElementById("error");
  error.style.display = "";
  let msg_elem = document.querySelector("#error p");
  msg_elem.textContent = msg;
  document.querySelector("canvas").setAttribute("class", "error");
}

window.onerror = function (msg, _url, _lineNo, _columnNo, _error) {
  if (msg.includes("RuntimeError")) {
    if (document.querySelector("canvas").getContext("webgl2") == null) {
      show_error("Running the game failed. Your browser does not support webgl2.");
    } else {
      show_error("Encountered an unexpected internal error while running the game.");
    }
  }
}